IF IndexProperty(Object_Id('Clientes_CtaCte'), 'IX_CliCtaCte_Saldo', 'IndexID') IS NOT NULL	
DROP INDEX [IX_CliCtaCte_Saldo] ON [dbo].[Clientes_CtaCte]
GO
IF IndexProperty(Object_Id('Clientes_CtaCte'), 'IX_Cli_CTACTE_Estado_Saldo', 'IndexID') IS NOT NULL		
	DROP INDEX [IX_Cli_CTACTE_Estado_Saldo] ON [dbo].[Clientes_CtaCte]
GO

IF IndexProperty(Object_Id('Clientes_CtaCte'), 'IX_CLICTA_Estado_Cbte', 'IndexID') IS NOT NULL		
	DROP INDEX [IX_CLICTA_Estado_Cbte] ON [dbo].[Clientes_CtaCte]
GO

ALTER TABLE Clientes_CtaCte ALTER COLUMN Saldo DECIMAL(20,2)
ALTER TABLE Clientes_CtaCte ALTER COLUMN Importe DECIMAL(20,2)

CREATE NONCLUSTERED INDEX [IX_CliCtaCte_Saldo] ON [dbo].[Clientes_CtaCte]
(
	[Saldo] ASC
)
INCLUDE ( 	[Fecha_Vence],
	[Descripcion],
	[Importe]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
GO

CREATE NONCLUSTERED INDEX [IX_Cli_CTACTE_Estado_Saldo] ON [dbo].[Clientes_CtaCte]
(
	[Id_Estado_Cbte] ASC,
	[Saldo] ASC
)
INCLUDE ( 	[Id_Cliente],
	[Fecha_Vence],
	[Descripcion],
	[Importe]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
GO

CREATE NONCLUSTERED INDEX [IX_CLICTA_Estado_Cbte] ON [dbo].[Clientes_CtaCte]
(
	[Id_Estado_Cbte] ASC
)
INCLUDE ( 	[Importe]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
GO
